
  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Wed Nov 17 17:25:55 2004
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version DX_CRYPTO_DES.c#1:csrc:6
   *  \author adams
   *  \remarks Copyright (C) 2004 by Discretix Technologies Ltd.
   *           All Rights reserved
   */



/************* Include Files ****************/
#include <linux/init.h>
#include <linux/module.h>
#include <crypto/algapi.h>
#include "BaseTypes.h"
#include "error.h"


/************************ Public Functions ******************************/
extern int dx_aes_init(void);
extern void dx_aes_finish(void);
extern int dx_des_init(void);
extern void dx_des_finish(void);
extern int dx_hash_init(void);
extern void dx_hash_finish(void);

int __init crypto_crys_init(void);
void __exit crypto_crys(void);

/*--------------------------------------------------------------
  init function 
----------------------------------------------------------------*/
int __init crypto_crys_init(void)
{ 
/* The return error identifier */
uint32_t error;

/* initializing the error to O.K */
error = DX_OK; 

    pr_debug("\n start: crypto_crys_init");
    
	error = dx_aes_init();
	if (error != DX_NULL) 
		goto aes_init_err;

	error = dx_des_init();
	if (error != DX_NULL) 
		goto des_init_err;

	error = dx_hash_init();
	if (error != DX_NULL) 
		goto hash_init_err;

    pr_debug("\n finish: crypto_crys_init");
    
	return DX_OK;
    
hash_init_err:
	dx_hash_finish();     
des_init_err:
	dx_aes_finish();
aes_init_err:
	return error;
}


/*-------------------------------------------------------------
  exit function 
--------------------------------------------------------------*/
void __exit crypto_crys_exit(void)
{
   
    pr_debug("\n start: crypto_crys_exit");    
    
	dx_aes_finish();

	dx_des_finish();

	dx_hash_finish();

    pr_debug("\n start: crypto_crys_exit");
}


module_init (crypto_crys_init);
module_exit (crypto_crys_exit);
MODULE_LICENSE("GPL");
